/***************************************************************************
 *
 * Copyright (C) 2001 International Business Machines
 * All rights reserved.
 *
 * This file is part of the GPFS mmfslinux kernel module.
 *
 * Redistribution and use in source and binary forms, with or without 
 * modification, are permitted provided that the following conditions 
 * are met:
 *
 *  1. Redistributions of source code must retain the above copyright notice, 
 *     this list of conditions and the following disclaimer. 
 *  2. Redistributions in binary form must reproduce the above copyright 
 *     notice, this list of conditions and the following disclaimer in the
 *     documentation and/or other materials provided with the distribution. 
 *  3. The name of the author may not be used to endorse or promote products 
 *     derived from this software without specific prior written
 *     permission. 
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR 
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES 
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. 
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *************************************************************************** */
/*
 * $Id: arch-gpl.h,v 1.16.4.1 2002/05/21 21:44:58 dcraft Exp $
 *
 * $Log: arch-gpl.h,v $
 * Revision 1.16.4.1  2002/05/21 21:44:58  dcraft
 * Pull GPFS 1.2.1 up to kernel 2.4.18.
 * mmfsfuncs.Linux must be distributed with /usr/lpp/mmfs/src
 * on developerworks.
 *
 * Revision 1.16  2001/09/22 20:07:56  dcraft
 * Remove kiobufs from cxiKernelIODescriptor_t.  Use temporary
 * kiobufs for map/unmap.   Remove dead code and dead comments
 * in portability layer and update readmes and license.
 * Fix traceback to appear in mmfs.log file.
 *
 * Revision 1.15  2001/09/21 22:54:29  yuri
 * Remove core dump code.
 *
 * Revision 1.14  2001/09/19 23:40:01  eshel
 * Add privilege level support for linux ia64.
 *
 * Revision 1.13  2001/08/09 21:11:15  dcraft
 * Modifications to allow running on latest Redhat 7.1 update
 * Kernel version 2.4.3-12.
 * Requires checkout of new site.mcr.proto
 *
 * Revision 1.12  2001/04/21 01:04:24  wyllie
 * Use new infrastructure for allocating and making accessible memory shared
 * between the kernel and the daemon.
 *
 * Revision 1.11  2001/03/20 22:58:41  eshel
 * Add option to kxSaveThreadInfo() to get regs.
 *
 * Revision 1.10  2001/02/26 17:33:13  dcraft
 * Pare down unused code pieces.  Run cindent.
 *
 * Revision 1.9  2001/02/19 23:16:11  dcraft
 * split elfdump out so we can control whether we ship it (tcore dump may
 * be available in some distributions).  Must be turned on in site.mcr
 *
 * Revision 1.8  2001/01/28 20:42:52  dcraft
 * Invoke lcrash for kernel thread tracebacks.  Mod kxDumpTraceBack()
 * to allow a file name for output.  Normal ksymoops is backup if
 * lcrash isn't present.
 *
 * Revision 1.7  2000/12/18 13:53:11  gjertsen
 * More cleanup of comments/documentation.
 *
 * Revision 1.6  2000/12/05 19:12:42  eshel
 * Add code for core dump on ia64.
 *
 * Revision 1.5  2000/11/30 22:11:28  eshel
 * Add and move code for ia64.
 *
 * Revision 1.4  2000/11/29 04:38:06  eshel
 * Add code to get thread traceback from a core file.
 *
 * Revision 1.3  2000/11/09 01:31:56  eshel
 * Move more code to common routines for ia64 and i386.
 *
 * Revision 1.2  2000/11/08 00:51:13  eshel
 * Fix ia64 compile.
 *
 * Revision 1.1  2000/11/07 22:39:50  eshel
 * Add header file for common arch.
 *
 */
#ifndef _h_arch_gpl
#define _h_arch_gpl

#define LEVEL_1 // uncomment to get privilege level 1 where the storage is
                // NOT accessible by all users ???

#ifdef GPFS_ARCH_IA64
/* In the kernel's mapped region we have a full 43 bit space available and
   completely ignore the region number (since we know its in region number 5).*/
#define PGD_OFFSET(mm, page) pgd_offset_k(page)
#ifdef LEVEL_1
#define PRIVILEGE_FLAGS _PAGE_PL_1           // privilege level 1
#else
#define PRIVILEGE_FLAGS _PAGE_PL_3           // privilege level 3(user)
#endif
#else   //GPFS_ARCH_I386
#define PRIVILEGE_FLAGS _PAGE_USER
#define PGD_OFFSET(mm, page) pgd_offset(mm, page)
#endif

int kxSaveThreadInfo(int pid, void* reg);
int set_privilege_level(unsigned long progLevel);
int get_privilege_level();

/* General macros for flushing tlb entries */
#ifdef GPFS_ARCH_POWER
#define FLUSH_TLB_PAGE(V,A)            NOOP //???
#define FLUSH_TLB_RANGE(M,S,E)         NOOP //???
#endif
#ifdef GPFS_ARCH_I386
#define FLUSH_TLB_PAGE(V,A)            flush_tlb_page(V,A)
/* flush_tlb_range and flush_tlb_all are not exported from i386
   kernel and are not currently needed. */
#define FLUSH_TLB_RANGE(M,S,E)
#define FLUSH_TLB_ALL()
#endif /* GPFS_ARCH_I386 */

#ifdef GPFS_ARCH_IA64
/* Disable individual page flushing for now; under certain circumstances
 * the entire TBL cache must be flushed. Waiting for flush_tlb_page export
 * to get "flushed" from kernel.org source into RH kernel. */
#undef FAST_TBL_FLUSH
#ifdef FAST_TLB_FLUSH
/* flush_tlb_page and flush_tlb_range are not exported from ia64 kernel */
extern void flush_tlb_page_ia64(unsigned long start_addr);
extern void flush_tlb_range_ia64(unsigned long start_addr,
                                 unsigned long end_addr);
#define FLUSH_TLB_PAGE(V,A)            flush_tlb_page_ia64((unsigned long)A)
#define FLUSH_TLB_RANGE(M,S,E)         flush_tlb_range_ia64((unsigned long)S,(unsigned long)E)
#define FLUSH_TLB_ALL()                flush_tlb_all()
#else
#define FLUSH_TLB_PAGE(V,A)            flush_tlb_all()
#define FLUSH_TLB_RANGE(M,S,E)         flush_tlb_all()
#define FLUSH_TLB_ALL()                flush_tlb_all()
#endif
#endif /* GPFS_ARCH_IA64 */

#endif /* _h_arch_gpl */
